#!/usr/bin/env bash
#===============================================================================
#
#          FILE: start.sh
#
#         USAGE: ./start.sh
#        AUTHOR: Alexander Wolf (SinglWolf), singlwolf@qip.ru
#  ORGANIZATION: Forum Mini-Server.ru
#       CREATED: 30.11.2013 22:09:45 YEKT
#      REVISION:  -----
# Copyright (c) 2013, Alexander Wolf
#===============================================================================
clear
tmprootdir="$(dirname $0)"
echo ${tmprootdir} | grep '^/' >/dev/null 2>&1
if [ X"$?" == X"0" ]; then
export ROOTDIR="${tmprootdir}"
else
export ROOTDIR="$(pwd)"
fi
export CONF_DIR="${ROOTDIR}/conf"
cd ${ROOTDIR}
. ${CONF_DIR}/var.sh
. ${CONF_DIR}/functions.sh
check_user root
check_lock
check_hardware
. ${CONF_DIR}/check_distr.sh
check_pkg dialog dialog
. ${CONF_DIR}/welcome.sh
if
[ X"${DISTRO}" == X"DEBIAN" -o X"${DISTRO}" == X'UBUNTU' ]; then
cd ${ROOTDIR}/deb
. setup.sh
else
error_exit
fi
