#!/usr/bin/env bash
#===============================================================================
#
#          FILE: roundcube.sh
#
#         USAGE: ./roundcube.sh
#        AUTHOR: Alexander Wolf (SinglWolf), singlwolf@qip.ru
#  ORGANIZATION: Forum Mini-Server.ru
#       CREATED: 24.09.2013 22:37:37 YEKT
#      REVISION:  -----
# Copyright (c) 2013, Alexander Wolf
#===============================================================================
cd ${ROUNDCUBE}
clear
appsdir="${APPSDIR}roundcube"
RCNUMBER="0.7.2"
RCPACKED="roundcubemail-"$RCNUMBER".tar.gz"
RCUNPACKED="roundcubemail-"$RCNUMBER
ECHO_INFO "Εγκατάσταση Roundcube.\n"
ECHO_INFO " Κατέβασμα αρχείων από downloads.sourceforge.net\n"
wget -N "http://downloads.sourceforge.net/project/roundcubemail/roundcubemail/"$RCNUMBER"/"$RCPACKED >> ${I_Info} 2>> ${I_Err}
extract_pkg  $RCPACKED
check_error
PASSROOT=${password_MySQL}
DBUSER="ispapp1"
DBPASS=$(gen_pass)
DBNAME="ispapp1"
DBHOST="localhost"
mysql -uroot -p$PASSROOT -e "CREATE DATABASE $DBNAME COLLATE utf8_bin;"
mysql -uroot -p$PASSROOT -e "GRANT ALL PRIVILEGES ON $DBNAME.* TO $DBUSER@localhost IDENTIFIED by '$DBPASS' WITH GRANT OPTION;"
mysql -u$DBUSER -p$DBPASS $DBNAME < $RCUNPACKED/SQL/mysql.initial.sql
mkdir -p $appsdir
mv -f $RCUNPACKED/* $appsdir/
mv -f $RCUNPACKED"/.htaccess" $appsdir/
rm -rf $RCPACKED $appsdir"/installer" $appsdir"/CHANGELOG" $appsdir"/LICENSE" $appsdir"/README.md" $appsdir"/INSTALL" $appsdir"/UPGRADING" $appsdir"/SQL"
chown -R ispapps:ispapps $appsdir
chmod 755 $appsdir"/temp" $appsdir"/logs"
sed "22 s/.*/\$rcmail_config['db_dsnw'] = 'mysqli:\/\/$DBUSER:$DBPASS@$DBHOST\/$DBNAME';/" $appsdir"/config/db.inc.php.dist" > $appsdir"/config/db.inc.php"
sed "72 s/.*/\$rcmail_config[\'default_host\'] = \"localhost\";/" $appsdir"/config/main.inc.php.dist" > $appsdir"/config/main.inc.php"
sed "135  s/.*/\$rcmail_config['smtp_server'] = \"\%h\";/" $appsdir"/config/main.inc.php" > $appsdir"/config/main.inc.php.tmp"
mv -f $appsdir"/config/main.inc.php.tmp" $appsdir"/config/main.inc.php"
sed "142  s/.*/\$rcmail_config['smtp_user'] = \"\%u\";/" $appsdir"/config/main.inc.php" > $appsdir"/config/main.inc.php.tmp"
mv -f $appsdir"/config/main.inc.php.tmp" $appsdir"/config/main.inc.php"
sed "146  s/.*/\$rcmail_config['smtp_pass'] = \"\%p\";/" $appsdir"/config/main.inc.php" > $appsdir"/config/main.inc.php.tmp"
mv -f $appsdir"/config/main.inc.php.tmp" $appsdir"/config/main.inc.php"
sed "361 s/.*/\$rcmail_config[\'plugins\'] = array(\"jqueryui\",\"ispconfig3_account\", \"ispconfig3_autoreply\", \"ispconfig3_fetchmail\", \"ispconfig3_filter\", \"ispconfig3_forward\", \"ispconfig3_pass\", \"ispconfig3_spam\", \"ispconfig3_wblist\");/" $appsdir"/config/main.inc.php" > $appsdir"/config/main.inc.php.tmp"
mv -f $appsdir"/config/main.inc.php.tmp" $appsdir"/config/main.inc.php"
sed "425  s/.*/\$rcmail_config['create_default_folders'] = TRUE;/" $appsdir"/config/main.inc.php" > $appsdir"/config/main.inc.php.tmp"
mv -f $appsdir"/config/main.inc.php.tmp" $appsdir"/config/main.inc.php"
sed "431 s/.*/\$rcmail_config['quota_zero_as_unlimited'] = TRUE;/" $appsdir"/config/main.inc.php" > $appsdir"/config/main.inc.php.tmp"
mv -f $appsdir"/config/main.inc.php.tmp" $appsdir"/config/main.inc.php"
if [  -e "/etc/fail2ban/filter.d/roundcube.conf"  ] ; then
:
else
cat << EOF >> /etc/fail2ban/jail.local
[roundcube]
enabled  = true
port     = http,2083,2082,https
filter   = roundcube
logpath  = /var/log/roundcube/userlogins
maxretry = 5
EOF
cat << EOF > /etc/fail2ban/filter.d/roundcube.conf
[Definition]
failregex = FAILED login for .*. from <HOST>
ignoreregex =
EOF
/etc/init.d/fail2ban restart
fi
cat << EOF > /etc/apache2/conf.d/roundcube.conf
Alias /webmail /var/www/apps/roundcube
<Directory /var/www/apps/roundcube>
Options +FollowSymLinks
DirectoryIndex index.php
<IfModule mod_php5.c>
AddType application/x-httpd-php .php
php_flag magic_quotes_gpc Off
php_flag track_vars On
php_flag register_globals Off
php_value include_path .
</IfModule>
AllowOverride All
Order Deny,Allow
Allow from All
</Directory>
<Directory /var/www/apps/roundcube/temp>
Options -FollowSymLinks
AllowOverride None
Order Deny,Allow
Deny from All
</Directory>
<Directory /var/www/apps/roundcube/logs>
Options -FollowSymLinks
AllowOverride None
Order Deny,Allow
Deny from All
</Directory>
<DirectoryMatch \.svn>
Order Deny,Allow
Deny from All
</DirectoryMatch>
EOF
service apache2 reload >> ${I_Info} 2>> ${I_Err}
ECHO_INFO "Εγκατάσταση Roundcube ολοκληρώθηκε."
sleep 3
set_lock 0
