#!/usr/bin/env bash
#===============================================================================
#
#          FILE: index.sh
#
#         USAGE: ./index.sh
#        AUTHOR: Alexander Wolf (SinglWolf), singlwolf@qip.ru
#  ORGANIZATION: Forum Mini-Server.ru
#       CREATED: 21.02.2014 12:25:54 YEKT
#      REVISION:  -----
# Copyright (c) 2014, Alexander Wolf
#===============================================================================
if [ -f /usr/local/ispconfig/interface/ssl/ispserver.crt ]; then
link_isp="https://${IP_HOST}:2083"
else
link_isp="http://${IP_HOST}:2083"
fi
server="Nginx όπως frontend + Apache όπως backend"
if [ X"${ENGINE_SERVER}" == X'nginx' -a X"${LIGAMENT}" == X"OFF" ]; then
server="μόνο NGINX"
fi
if [ X"${ENGINE_SERVER}" == X'apache' -a X"${LIGAMENT}" == X"OFF" ]; then
server="μόνο Apache2"
fi
proginstall=${PROG_NAME_LOWERCASE}-${PROG_VERSION}
cat << EOF > /var/www/index.html
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
<head>
<title>Καλώς ήρθατε!</title>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
<link rel="shortcut icon" href="/favicon.ico" />
<meta name="robots" content="noindex" />
<style type="text/css"><!--
body {
color: #444444;
background-color: #EEEEEE;
font-family: 'Trebuchet MS', sans-serif;
font-size: 80%;
}
h1 {}
h2 { font-size: 1.2em; }
background-color: #FFFFFF;
width: 60%;
margin: 24px auto;
padding: 12px;
}
padding: 6px ;
text-align: center;
}
.header{ background-color: #83A342; color: #FFFFFF; }
padding: 4px 0 24px 0;
}
color: #666666;
background: #f9f9f9;
padding: 10px 20px;
border-top: 5px #efefef solid;
font-size: 0.8em;
text-align: center;
}
color: #999999;
}
color: #666666;
background: #f9f9f9;
padding: 10px 20px;
border-top: 5px #efefef solid;
font-size: 0.8em;
text-align: center;
}
color: #999999;
}
h3 {
color: #F00;
}
--></style>
</head>
<body>
<div id="page">
<div id="header_">
<p>Πίνακας Ελέγχου <a href="http://www.ispconfig.org">ISPConfig</a> είναι εγκατεστημένο με χρήση του script <a href="http://forum.mini-server.ru/viewtopic.php?f=33&t=764">${proginstall}</a></p>
</div>
<div id="header" class="header">
<h1>Καλώς ήρθατε στο ISPConfig 3!</h1>
<h3>Στο διακομιστή σας εγκατεστημένο ${server}</h3>
</div>
<div id="content">
<h2>	Αυτή η σελίδα καλωσορίσματος, το οποία έχει παραχθεί με χρήση του script  από <a href="http://forum.mini-server.ru/viewtopic.php?f=33&t=764">${proginstall}</a> εγκατάσταση του πίνακα ελέγχου Web-φιλοξενίας ISPConfig 3, αυτόματα και μπορεί να ξαναγραφεί χωρίς καμία συνέπεια. Αυτό το αρχείο ονομάζεται <b>index.html</b> και βρίσκεται στο κατάλογο <b> /var/www</b>.</h2>
<p>Για να μεταβείτε στο πίνακας ελέγχου, κάντε κλικ σε αυτό το σύνδεσμο <a href="${link_isp}">Πίνακας Ελέγχου</a></p>
<p></p>
<p>Αν έχετε ερωτήσεις ή απορίες, επικοινωνήστε με το σύνδεσμο: <a href="${LINK_SUPPORT}">Ερώτηση</a>.</p>
</div>
<div id="footer">
<p>Πίνακας Ελέγχου <a href="http://www.ispconfig.org">ISPConfig</a> εγκατεστημένο με χρήση του script  <a href="http://forum.mini-server.ru/viewtopic.php?f=33&t=764">${proginstall}</a></p>
</div>
</div>
</body>
</html>
EOF
