#!/usr/bin/env bash
#===============================================================================
#
#          FILE: get_all.sh
#
#         USAGE: ./get_all.sh
#        AUTHOR: Alexander Wolf (SinglWolf), singlwolf@qip.ru
#  ORGANIZATION: Forum Mini-Server.ru
#       CREATED: 24.09.2013 22:38:55 YEKT
#      REVISION:  -----
# Copyright (c) 2013, Alexander Wolf
#===============================================================================
check_hostname
passw_MySQL
export progress_bar="10" list="Εγκατάσταση ssh openssh-server debconf-utils και άλλα."
pkg_install ssh openssh-server debconf-utils ntp ntpdate
if [ -f postfix.preseed ]; then
pkg_remove postfix >> ${I_Info} 2>> ${I_Err}
check_error
fi
export progress_bar="20" list="Εγκατάσταση Postfix"
cat <<EOF > postfix.preseed
postfix postfix/mailname        string ${FULL_HOSTNAME}
postfix postfix/main_mailer_type        select  Internet Site
postfix postfix/destinations string localhost.localdomain, ${FULL_HOSTNAME}
EOF
cat postfix.preseed | debconf-set-selections
pkg_install postfix
if [ -f mysql.preseed ]; then
pkg_remove mysql-server >> ${I_Info} 2>> ${I_Err}
check_error
fi
export progress_bar="30" list="Εγκατάσταση mysql-server"
if
[ X"${DISTRO_CODENAME}" == X"squeeze" ]; then
_mysql='mysql-server-5.1'
else _mysql='mysql-server-5.5'
fi
cat << EOF > mysql.preseed
${_mysql}        mysql-server/root_password_again        password ${password_MySQL}
${_mysql}        mysql-server/root_password      password ${password_MySQL}
${_mysql}        ${_mysql}/start_on_boot  boolean true
EOF
cat mysql.preseed | debconf-set-selections
pkg_install mysql-server
if
[ X"${DISTRO_CODENAME}" == X"squeeze" ]; then
unset deb1 deb2 deb3
else
deb1=' dovecot-mysql dovecot-sieve'
deb2=' libclass-dbi-mysql-perl'
deb3=' binutils-gold'
fi
export progress_bar="40" list="Εγκατάσταση ταχυδρομικών υπηρεσιών"
pkg_install openssl postfix-mysql postfix-doc mysql-client getmail4 rkhunter binutils dovecot-imapd dovecot-pop3d${deb1} sudo
export progress_bar="50" list="Εγκατάσταση antivirus ClamAV, anti-spam και συνοδευτικών εργαλείων "
pkg_install amavisd-new spamassassin clamav clamav-base clamav-daemon clamav-docs zoo unzip bzip2 arj nomarch lzop cabextract apt-listchanges libnet-ldap-perl libauthen-sasl-perl daemon libio-string-perl libio-socket-ssl-perl libnet-ident-perl zip libnet-dns-perl
export progress_bar="60" list="Εγκατάσταση ενός διακομιστή web apache2, ssl-cert, php5, imagemagick και άλλα."
pkg_install apache2 apache2.2-common apache2-doc apache2-mpm-prefork apache2-utils libexpat1 ssl-cert libapache2-mod-php5 php5 php5-common php5-gd php5-mysql php5-imap php5-cli php5-cgi libapache2-mod-fcgid apache2-suexec php-pear php-auth php5-mcrypt mcrypt php5-imagick imagemagick libapache2-mod-suphp libruby libapache2-mod-ruby libapache2-mod-python php5-curl
cat <<EOF > phpmyadmin.preseed
phpmyadmin      phpmyadmin/reconfigure-webserver        multiselect     apache2
phpmyadmin      phpmyadmin/dbconfig-install     boolean false
phpmyadmin      phpmyadmin/database-type        select  mysql
phpmyadmin      phpmyadmin/internal/skip-preseed        boolean true
EOF
cat phpmyadmin.preseed | debconf-set-selections
export progress_bar="70" list="Εγκατάσταση phpmyadmin"
pkg_install phpmyadmin
export progress_bar="75" list="Εγκατάσταση ενοτήτων για apache2"
if
[ X"${DISTRO_CODENAME}" == X"precise" -o X"${DISTRO_CODENAME}" == X"squeeze" ]; then
pkg_install libapache2-mod-perl2
else pkg_install php5-intl php5-memcache php5-memcached php5-ming php5-ps php5-pspell php5-recode php5-snmp php5-sqlite php5-tidy php5-xmlrpc php5-xsl memcached
fi
if
[ X"${DISTRO_CODENAME}" != X"squeeze" ]; then
export progress_bar="80" list="Εγκατάσταση ενοτήτων για php5"
pkg_install php5-xcache libapache2-mod-fastcgi php5-fpm
a2enmod actions fastcgi alias >/dev/null 2>&1
else
:
fi
export progress_bar="85" list="Εγκατάσταση Διακομιστή-ftp και λειτουργίες Quota"
pkg_install pure-ftpd-common pure-ftpd-mysql quota quotatool
export progress_bar="90" list="Εγκατάσταση DNS-Διακομιστή, βοηθητικά προγράμματα για την εμφάνιση στατιστικών στοιχείων, geoip-database και άλλα."
pkg_install fail2ban bind9 dnsutils vlogger webalizer awstats geoip-database${deb2}
if ! [ -f /etc/cron.d/awstats.isp ]; then
cp /etc/cron.d/awstats /etc/cron.d/awstats.isp
sed -i 's/^/#/' /etc/cron.d/awstats
else
:
fi
export progress_bar="95" list="Εγκατάσταση πακέτων για μεταγλώττιση Jailkit"
pkg_install build-essential autoconf automake1.9 libtool libz-dev flex bison debhelper${deb3}
echo "100" | ${DIALOG} --gauge "Απαραίτητα πακέτα είναι εγκατεστημένα ." 10 50 0
sleep 3
clear
make_ssl
clear
clear
ECHO_INFO " Τώρα θα ρυθμιστούν τα αρχεία ρυθμίσεων και θα γίνει επανεκκίνηση υπηρεσιών...\n"
sleep 2
echo "dash    dash/sh boolean false" > dash.preseed
cat  dash.preseed | debconf-set-selections
dpkg-reconfigure -f noninteractive dash
echo ${FULL_HOSTNAME} > /etc/hostname
if
[ X"${DISTRO}" == X"UBUNTU" ]; then
/etc/init.d/hostname restart >> ${I_Info} 2>> ${I_Err}
/etc/init.d/apparmor stop >> ${I_Info} 2>> ${I_Err}
update-rc.d -f apparmor remove  >> ${I_Info} 2>> ${I_Err}
pkg_remove apparmor apparmor-utils >> ${I_Info} 2>> ${I_Err}
else
/etc/init.d/hostname.sh start >> ${I_Info} 2>> ${I_Err}
fi
if ! [ -f /etc/hosts.isp ]; then
cp /etc/hosts /etc/hosts.isp
else
:
fi
sed -i -e '/127.0.0.1/d' /etc/hosts
sed -i -e '1 s/^/127.0.0.1\tlocalhost\tlocalhost.localdomain\n/;' /etc/hosts
if [ X"${OLD_HOSTNAME}" != X"${FULL_HOSTNAME}" ]; then
cp -f /etc/hosts /etc/hosts.old
sed -i s/"${IP_HOST}"/#"${IP_HOST}"/ /etc/hosts
echo -e "\n${IP_HOST}\t${FULL_HOSTNAME}\t${SHORT_HOSTNAME}" >> /etc/hosts
else
:
fi
if ! [ -f /etc/mysql/my.cnf.isp ]; then
cp /etc/mysql/my.cnf /etc/mysql/my.cnf.isp
sed -i -e 's/bind-address/# bind-address/' /etc/mysql/my.cnf
else
:
fi
if ! [ -f ${MASTER_CF}.isp ]; then
cp ${MASTER_CF} ${MASTER_CF}.isp
sed -i -e 's/#smtps/smtps/' ${MASTER_CF}
sed -i -e 's/#submission/submission/' ${MASTER_CF}
sed -i -e 's/#  -o syslog_name/  -o syslog_name/' ${MASTER_CF}
if [ X"${DISTRO_CODENAME}" == X'raring' ]; then
sed -i -e 's/#  -o smtpd_tls_security_level=encrypt/  -o smtpd_tls_security_level=encrypt/' ${MASTER_CF}
sed -i -e 's/#  -o smtpd_sasl_auth_enable=yes/  -o smtpd_sasl_auth_enable=yes\n  -o smtpd_client_restrictions=permit_sasl_authenticated,reject/' ${MASTER_CF}
else
sed -i -e 's/#  -o smtpd_/  -o smtpd_/' ${MASTER_CF}
fi
else
:
fi
if [ X"${DISTRO_CODENAME}" == X"wheezy" -o X"${DISTRO_CODENAME}" == X'raring' ]; then
if ! [ -f /etc/apache2/mods-available/suphp.conf.isp ]; then
cp /etc/apache2/mods-available/suphp.conf /etc/apache2/mods-available/suphp.conf.isp
sed -i '2,4s/^/#/' /etc/apache2/mods-available/suphp.conf
sed -i '5s/^/\tAddType application\/x-httpd-suphp \.php \.php3 \.php4 \.php5 \.phtml\n/' /etc/apache2/mods-available/suphp.conf;
else
:
fi
else
:
fi
if [ X"${DISTRO_CODENAME}" != X"squeeze" ]; then
if ! [ -f /etc/mime.types.isp ]; then
cp /etc/mime.types /etc/mime.types.isp
sed -i 's/application\/x-ruby/#application\/x-ruby/' /etc/mime.types
else
:
fi
else
:
fi
a2enmod suexec rewrite ssl actions include dav_fs dav auth_digest${module5}
/etc/init.d/apache2 restart
if ! [ -f /etc/default/pure-ftpd-common.isp ]; then
cp /etc/default/pure-ftpd-common /etc/default/pure-ftpd-common.isp
sed -i -e 's/VIRTUALCHROOT=false/VIRTUALCHROOT=true/' /etc/default/pure-ftpd-common
else
:
fi
if [ X"${DISTRO_CODENAME}" == X"squeeze" ] && cat "/etc/inetd.conf" | grep "ftp    stream  tcp"  &> /dev/null; then
if ! [ -f /etc/inetd.conf.isp ]; then
cp /etc/inetd.conf /etc/inetd.conf.isp;
sed -i -e 's/ftp    stream  tcp/#ftp    stream  tcp/' /etc/inetd.conf
/etc/init.d/openbsd-inetd restart
else
:
fi
else
:
fi
/etc/init.d/mysql restart
/etc/init.d/postfix restart
/etc/init.d/spamassassin stop;
update-rc.d -f spamassassin remove
echo 1 > /etc/pure-ftpd/conf/TLS
/etc/init.d/pure-ftpd-mysql restart
if ! [ -f /etc/fstab.isp ]; then
cp /etc/fstab /etc/fstab.isp
sed -i -e 's/errors=remount-ro/errors=remount-ro,usrjquota=aquota.user,grpjquota=aquota.group,jqfmt=vfsv0/' /etc/fstab
else
:
fi
if ! [ -f /etc/apache2/conf.d/error_page.conf ]; then
cat << EOF > /etc/apache2/conf.d/error_page.conf
Alias /error/ "/usr/local/ispconfig/server/conf-custom/error/el/"
<Directory "/usr/local/ispconfig/server/conf-custom/error/el/">
Options FollowSymLinks
AllowOverride None
Order allow,deny
allow from all
</Directory>
ErrorDocument 400 /error/400.html
ErrorDocument 401 /error/401.html
ErrorDocument 403 /error/403.html
ErrorDocument 404 /error/404.html
ErrorDocument 405 /error/405.html
ErrorDocument 500 /error/500.html
ErrorDocument 502 /error/502.html
ErrorDocument 503 /error/503.html
EOF
else
:
fi
mount -o remount /
quotacheck -avugmf >> ${I_Info} 2>> ${I_Err}
quotaon -avugf >> ${I_Info} 2>> ${I_Err}
gen_fail2ban
/etc/init.d/fail2ban restart
clear
info=" Μεταγλώττιση και εγκατάσταση JailKit έκδοσης 2.17"
ECHO_INFO "${info}.\nΠαρακαλώ περιμένετε...\n"
wget -N http://olivier.sessink.nl/jailkit/jailkit-2.17.tar.gz >> ${I_Info} 2>> ${I_Err}
check_error
extract_pkg jailkit-2.17.tar.gz
cd jailkit-2.17
./debian/rules binary >> ${I_Info} 2>> ${I_Err}
cd ..
dpkg -i jailkit_2.17-1_*.deb >> ${I_Info} 2>> ${I_Err}
check_error
. ${ROOTDIR}/deb/index.sh
ECHO_INFO "${info} ολοκληρώθηκε.\n"
sleep 3
clear
