#!/usr/bin/env bash
#===============================================================================
#
#          FILE: check_repo.sh
#
#         USAGE: ./check_repo.sh
#        AUTHOR: Alexander Wolf (SinglWolf), singlwolf@qip.ru
#  ORGANIZATION: Forum Mini-Server.ru
#       CREATED: 23.11.2013 10:29:57 YEKT
#      REVISION:  -----
# Copyright (c) 2013, Alexander Wolf
#===============================================================================
clear
ECHO_INFO "\nΤώρα θα γίνει ρύθμιση συστήματος.\n
Αυτό μπορεί να πάρει κάποιο χρόνο.\n
Σας παρακαλώ να έχετε υπομονή."
sleep 3
if [ -f "/var/lib/apt/lists/lock" ]; then
rm /var/lib/apt/lists/lock
fi
dpkg --configure -a >> ${I_Info} 2>> ${I_Err}
check_error
ECHO_INFO "\προσθήκη απαραίτητων κλειδιών και αποθετηρίων."
export distro="$(echo ${DISTRO} | tr '[A-Z]' '[a-z]')"
if [ -f "/etc/apt/sources.list.isp" ]; then
mv /etc/apt/sources.list.isp /etc/apt/sources.list
fi
mv /etc/apt/sources.list /etc/apt/sources.list.isp
cp sources.list.${distro} sources.list
if [ X"${distro}" == X'ubuntu' ]; then
if [ X"${DISTRO_CODENAME}" == X'raring' ]; then
sed -i -e 's/precise/raring/' sources.list
fi
fi
if [ X"${distro}" == X'debian' ]; then
if [ X"${DISTRO_CODENAME}" == X'squeeze' ]; then
sed -i -e 's/wheezy/squeeze/' sources.list
cat << EOF >> sources.list
deb http://packages.dotdeb.org squeeze all
deb-src http://packages.dotdeb.org squeeze all
EOF
wget http://www.dotdeb.org/dotdeb.gpg >> ${I_Info} 2>> ${I_Err}
check_error
cat dotdeb.gpg | apt-key add -
rm -rf dotdeb.gpg
fi
fi
mv sources.list /etc/apt/sources.list
ECHO_INFO "\nΑνανέωση λίστας με τα αποθετήρια."
apt-get update >> ${I_Info} 2>> ${I_Err}
check_error
ECHO_INFO "\nΑνανέωση συστήματος."
apt-get dist-upgrade -y >> ${I_Info} 2>> ${I_Err}
check_error
ECHO_INFO " Το σύστημα έχει ρυθμιστεί με επιτυχία."
sleep 3
