#!/usr/bin/env bash
#===============================================================================
#
#          FILE: add.sh
#
#         USAGE: ./add.sh
#        AUTHOR: Alexander Wolf (SinglWolf), singlwolf@qip.ru
#  ORGANIZATION: Forum Mini-Server.ru
#       CREATED: 24.09.2013 07:07:59 YEKT
#      REVISION:  -----
# Copyright (c) 2013, Alexander Wolf
#===============================================================================
retval=99
while test $retval != 0 && test $retval != 250
do
clear
tempfile=`tempfile 2>/dev/null` || tempfile=/tmp/test$$
trap "rm -f $tempfile" 0 1 2 5 15
$DIALOG --item-help \
--title "  Επιλογή Web Server για το διακομιστή σας " "$@" \
--radiolist "Εδώ μπορείτε να επειλέξετε Web Server για το Διακομιστή σας.\n\
Πλοήγηση σε μενού και πλήκτρα  UP/DOWN\n\
Πλήκτρα πρόσβασης 1-9 για να επιλέξετε τις επιλογές. \n\
Πλήτκρο SPACE ενεργοποιεί τις ρυθμίσεις που επιλέξατε." 15 60 4 \
Apache	"Διαθέσιμο"	"on" "Apache - το πιο ευρέως χρησιμοποιούμενο Web Server για συστήματα GNU/Linux." \
Nginx "Μη διαθέσιμο"	"off" "${ZBold}${Zred}Διαθέσιμο στην full-έκδοση!!!!${Zreset_all}" \
Apache+Nginx "Διαθέσιμο" "off" "${ZBold}${Zred}Διαθέσιμο στην full-έκδοση!!!!${Zreset_all}" \
2> $tempfile
retval=$?
case $retval in
$DIALOG_OK)
radiolist=`cat $tempfile`
case $radiolist  in
Apache)
export ENGINE_SERVER='apache';;
Nginx)
export ENGINE_SERVER='apache';;
Nginx+Apache)
export ENGINE_SERVER='apache'
export LIGAMENT='OFF';;
esac;;
$DIALOG_CANCEL)
eval check_exit
;;
$DIALOG_ESC)
eval check_exit
;;
esac
done
retval=99
while test $retval != 0 && test $retval != 250
do
clear
tempfile=`tempfile 2>/dev/null` || tempfile=/tmp/test$$
trap "rm -f $tempfile" 0 1 2 5 15
$DIALOG --item-help \
--title "  Επιλογή επεκτάσεων διακομιστή  " "$@" \
--checklist "Εδώ μπορείτε να επιλέξετε επεκτάσεις και πρόσθετα για το Διακομιστή σας.\n\
Λίστα δεν είναι πλήρης. Με τις προτάσεις ανατρέξτε, στο νήμα του φόρουμ: \n\
${LINK_SUPPORT} \n\
Πλοήγηση σε μενού και πλήκτρα UP/DOWN\n\
Πλήκτρα πρόσβασης 1-9 για να επιλέξετε τις επιλογές. \n\
Πλήτκρο SPACE ενεργοποιεί και απενεργοποιεί τις ρυθμίσεις που επιλέξατε." 20 70 3 \
Webmin	"Μη διαθέσιμο"	"" "${ZBold}${Zred}Διαθέσιμο στην full-έκδοση!!!!${Zreset_all} Το γραφικό περιβάλλον εργασίας για τη διαχείριση του διακομιστή" \
MC "Μη διαθέσιμο"	"" "${ZBold}${Zred}Διαθέσιμο στην full-έκδοση!!!!${Zreset_all} ο διαχειριστής αρχείων με διεπαφή τύπου GNU Midnight Commander" \
2> $tempfile
retval=$?
case $retval in
$DIALOG_OK)
checklist=`cat $tempfile`;;
$DIALOG_CANCEL)
eval check_exit
;;
$DIALOG_ESC)
eval check_exit
;;
esac
done
