#!/usr/bin/env bash
#===============================================================================
#
#          FILE: welcome.sh
#
#         USAGE: ./welcome.sh
#        AUTHOR: Alexander Wolf (SinglWolf), singlwolf@qip.ru
#  ORGANIZATION: Forum Mini-Server.ru
#       CREATED: 24.09.2013 22:39:14 YEKT
#      REVISION:  -----
# Copyright (c) 2013, Alexander Wolf
#===============================================================================
clear
datedevelop=`ls --full-time  ${CONF_DIR}/var.sh | awk '{print$6}'`
timedevelop=`ls --full-time ${CONF_DIR}/var.sh | awk '{print substr($7,1,8)}'`
if [ X"${SUPPORTED_SCRIPT}" == X"NO" ]; then
WARNING="Κόκκινο χρώμα υποδεικνύει ότι η τρέχουσα έκδοση  ${ZBold}${Zmagenta}${PROG_NAME}${Zreset_all}\n
δεν υποστηρίξει την αρχιτεκτονική σας.";
WELCOM="${DIALOG} ";
_warning="${Zred}";
yesno="--msgbox";
else WARNING="Πράσινο χρώμα υποδεικνύει ότι η τρέχουσα έκδοση   ${ZBold}${Zmagenta}${PROG_NAME}${Zreset_all}
υποστηρίξει την αρχιτεκτονική σας. Όλα καλά.\n\n
Αυτό το πρόγραμμα διανέμεται υπό τους όρους του  \"\Zu\Z1As Is (Ως έχει)\Zn\" και με \Zu\Z1άδειας χρήσης GNU GPL\Zn,
το κείμενο της οποίας μπορείτε να διαβάσετε κάνοντας κλικ στο κουμπί \"ΑΔΕΙΑ\".
Κάντε κλικ στο κουμπί \"ΔΕΧΟΜΑΙ\", Συμφωνείτε με όλους τους όρους και τις προϋποθέσεις που αναφέρονται παραπάνω.";
WELCOM="${DIALOG} --help-button --defaultno --help-label ΑΔΕΙΑ --no-label ΔΕΝ_ΑΠΟΔΕΧΟΜΑΙ --yes-label ΣΥΜΦΩΝΩ";
_warning="${Zgreen}";
yesno="--yesno";
fi
retval=99
while test $retval != 0 && test $retval != 250
do
${WELCOM} \
--clear \
--cr-wrap \
--title "${TITLE_DIALOG}" \
$yesno "
\nΚαλώς ήρθατε! Ευχαριστούμε για την χρήση του προγράμματος ${ZBold}${Zmagenta}${PROG_NAME}${Zreset_all}\n\n
Έκδοση προγράμματος: ${Zyellow}${ZBold}${PROG_VERSION}${Zreset_all}
\n\n
Ημερομηνία κατασκευής:  ${ZBold}${Zblue}${datedevelop}\Zn
Ώρα κατασκευής: ${ZBold}${Zblue}${timedevelop}\Zn
\n\n
${ZBold}${Zred}Προσοχή! Αυτή η έκδοση DEMO !!! Με μειωμένη λειτουργικότητα!!${Zreset_all}
\n
Τα μηνύματα σφάλματος, τα σχόλια και οι προτάσεις σας είναι πάντα ευπρόσδεκτες.
\n\n
* Ιστοσελίδα Έργου: ${Zmagenta}${LINK_SUPPORT}${Zreset_all}
\n\n
Πληροφορίες για το σύστημα:
\n
Αρχιτεκτονική:	${_warning}${ARCH}${Zreset_all}\n
Διανομή:	${_warning}${DISTRO}${Zreset_all}\n
Έκδοση:     	${_warning}${DISTRO_VERSION}${Zreset_all}\n
Όνομα:        	${_warning}${DISTRO_CODENAME}${Zreset_all}\n
\n
${WARNING}
" 40 95
retval=$?
case $retval in
$DIALOG_OK)
;;
$DIALOG_HELP)
tempfile=`tempfile 2>/dev/null` || tempfile=/tmp/test$$
trap "rm -f $tempfile" 0 1 2 5 15
TEXT=${licenseGNU}
cat $TEXT | expand >> $tempfile
$DIALOG --clear --title " Άδεια Χρήσης " "$@" --textbox "$tempfile" 40 90
export ret=$?
case $ret in
$DIALOG_OK)
;;
$DIALOG_CANCEL)
;;
$DIALOG_ESC)
;;
esac
retval=99
;;
$DIALOG_ESC)
eval check_exit;;
$DIALOG_CANCEL)
eval check_exit;;
esac
done
clear
if [ X"${SUPPORTED_SCRIPT}" == X"NO" ]; then
error_exit
fi
