#!/usr/bin/env bash
#===============================================================================
#
#          FILE: var.sh
#
#         USAGE: ./var.sh
#        AUTHOR: Alexander Wolf (SinglWolf), singlwolf@qip.ru
#  ORGANIZATION: Forum Mini-Server.ru
#       CREATED: 01.12.2013 21:25:14 YEKT
#      REVISION:  -----
# Copyright (c) 2013, Alexander Wolf
#===============================================================================
export PROG_NAME='AutoInsallISPConfig'
export PROG_NAME_LOWERCASE="$(echo $PROG_NAME | tr '[A-Z]' '[a-z]')"
export PROG_VERSION='light'
export DATE="$(/bin/date +%Y.%m.%d\ %H:%M:%S)"
export LINK_SUPPORT='http://forum.mini-server.ru/viewtopic.php?f=33&t=764'
export BIN_DIALOG="dialog"
export PKG_DIALOG="dialog"
export BIN_BZIP2='bzip2'
export PKG_BZIP2='bzip2'
export ClamAV=${ROOTDIR}/clamav
export ROUNDCUBE=${ROOTDIR}/roundcube
export ISPCONFIG=${ROOTDIR}/ispconfig
export PHPMYADMIN=${ROOTDIR}/phpmyadmin
export licenseGNU=${ROOTDIR}/agpl.txt
export Ligament=${ROOTDIR}/ligament
export I_Info=${ROOTDIR}/info_install.log
export I_Err=${ROOTDIR}/error_install.log
export APPSDIR="/var/www/apps/"
export SHELL_BASH='/bin/bash'
export _ERROR_FLAG="< ΣΦΑΛΜΑ >"
export _OK_FLAG="< ΟΛΟΚΛΗΡΩΘΗΚΕ >"
export _INFO_FLAG="< ΠΛΗΡΟΦΟΡΙΑ >"
export _SKIP_FLAG="< ΛΕΙΠΕΙ >"
export _QUESTION_FLAG="< Ερώτηση >"
export _BACKUP_FLAG="+ < ΑΠΟΘΕΜΑ >"
export _DEBUG_FLAG="+ < ΕΚΤΕΛΕΙΤΑΙ >"
if [ X"${TERM}" == X"" ]; then
export TERM='xterm'
fi
export LIGAMENT='OFF'
export NUMBER_CORES="$(cat /proc/cpuinfo | grep "processor" | sort -u | wc -l)"
export RUN_ISP='install'
export ENGINE_SERVER=""
export FULL_HOSTNAME="$(hostname -f)"
export SHORT_HOSTNAME="$(hostname -s)"
export OLD_HOSTNAME=${FULL_HOSTNAME}
export IP_HOST=$(ifconfig eth0 | grep "inet addr" | head -n 1 | cut -d : -f 2 | cut -d " " -f 1)
cp /etc/timezone .
sed -i -e 's/\//\\\//' timezone
export TIME_ZONE="$(cat timezone)"
rm -f timezone
export MASTER_CF="/etc/postfix/master.cf"
export LOCK_FILE="/var/log/install.lock"
if [ X"$DISPLAY" == X"" ]
then
export ascii_lines="--ascii-lines"
else
export ascii_lines=""
fi;
export DIALOG="dialog ${ascii_lines} --colors --backtitle ${PROG_NAME}:_Απλή_Open_Source_Λύση_Εγκατάστασης_ISPConfig_3
"
export TITLE_DIALOG=' Το έργο του φόρουμ mini-server.ru '
: ${DIALOG_OK=0}
: ${DIALOG_CANCEL=1}
: ${DIALOG_HELP=2}
: ${DIALOG_EXTRA=3}
: ${DIALOG_ITEM_HELP=4}
: ${DIALOG_ESC=255}
export ZInvert='\Zr' ZInvert_unset='\ZR';
export Zblack='\Z0' Zred='\Z1' Zgreen='\Z2' Zyellow='\Z3' Zblue='\Z4' Zmagenta='\Z5' Zcyan='\Z6' Zwhite='\Z7';
export ZBold='\Zb' Zbold_unset='\ZB';
export Underline='\Zu' Underline_unset='ZU';
export Zreset_all='\Zn'
