#!/usr/bin/env bash
#===============================================================================
#
#          FILE: functions.sh
#
#         USAGE: ./functions.sh
#        AUTHOR: Alexander Wolf (SinglWolf), singlwolf@qip.ru
#  ORGANIZATION: Forum Mini-Server.ru
#       CREATED: 24.09.2013 22:39:49 YEKT
#      REVISION:  -----
# Copyright (c) 2013, Alexander Wolf
#===============================================================================
check_lock()
{
if [  -e "${LOCK_FILE}"  ] ; then
lock_file=`cat ${LOCK_FILE}`
case $lock_file in
0)
export lock_file="με το ${PROG_NAME}";;
255)
clear
ECHO_ERROR "Εντοπίστηκε την προηγούμενη εκτέλεση του script, που διακόπηκε!\n Εάν Είστε σίγουροι ότι θέλετε να εκτελέσετε το script για μια ακόμη φορά,\nαπασφαλίστε την εντολή \"echo \"0\" > ${LOCK_FILE}\""
exit 255;;
esac
else
export lock_file="χειροκίνητα";
fi
}
set_lock()
{
echo $1 > ${LOCK_FILE}
};
ECHO_INFO()
{
if [ X"$1" == X"-n" ]; then
shift 1
if [ X"${TERM}" == X"xterm" -o X"${TERM}" == X"linux" -o X"${TERM}" == X"pcconsole" ]; then
echo -ne "\033[42m${_INFO_FLAG}\033[0m $@"
else
echo -ne "${_INFO_FLAG} $@"
fi
else
if [ X"${TERM}" == X"xterm" -o X"${TERM}" == X"linux" -o X"${TERM}" == X"pcconsole" ]; then
echo -e "\033[42m${_INFO_FLAG}\033[0m $@"
else
echo -e "${_INFO_FLAG} $@"
fi
fi
}
check_user()
{
if [ X"$(id -u)" != X"$(id -u ${1})" ]; then
ECHO_ERROR " Παρακαλούμε εκτελέστε το script ως χρήστης: ${1}."
exit 0
else
if [ X"$(id -u)" == X"0" ]; then
export PATH="/usr/kerberos/sbin:/usr/kerberos/bin:/usr/local/sbin:/usr/local/bin:/sbin:/bin:/usr/sbin:/usr/bin:/root/bin"
else
:
fi
fi
}
ECHO_ERROR()
{
if [ X"$1" == X"-n" ]; then
shift 1
if [ X"${TERM}" == X"xterm" -o X"${TERM}" == X"linux" -o X"${TERM}" == X"pcconsole" ]; then
echo -ne "\033[41m${_ERROR_FLAG}\033[0m $@"
else
echo -ne "${_ERROR_FLAG} $@"
fi
else
if [ X"${TERM}" == X"xterm" -o X"${TERM}" == X"linux" -o X"${TERM}" == X"pcconsole" ]; then
echo -e "\033[41m${_ERROR_FLAG}\033[0m $@"
else
echo -e "${_ERROR_FLAG} $@"
fi
fi
}
ECHO_OK()
{
if [ X"${TERM}" != X"xterm" -o X"${TERM}" != X"linux" -o X"${TERM}" != X"pcconsole" ]; then
echo -e "\033[42m${_OK_FLAG}\033[0m $@"
else
echo -e "${_OK_FLAG} $@"
fi
}
ECHO_DEBUG()
{
if [ X"${IREDMAIL_DEBUG}" == X"YES" ]; then
if [ X"$1" == X"-n" ]; then
shift 1
if [ X"${TERM}" == X"xterm" -o X"${TERM}" == X"linux" -o X"${TERM}" == X"pcconsole" ]; then
echo -ne "\033[42m${_DEBUG_FLAG}\033[0m $@"
else
echo -ne "${_DEBUG_FLAG} $@"
fi
else
if [ X"${TERM}" == X"xterm" -o X"${TERM}" == X"linux" -o X"${TERM}" == X"pcconsole" ]; then
echo -e "\033[42m${_DEBUG_FLAG}\033[0m $@"
else
echo -e "${_DEBUG_FLAG} $@"
fi
fi
else
:
fi
}
install_bar_debian()
{
echo "${progress_bar}" | ${DIALOG} --gauge "${list}" 10 50 0
${APTGET} install -y $@ >> ${I_Info} 2>> ${I_Err}
if [ X"$?" != X"0" ]; then
echo ${progress_bar} | ${DIALOG} --gauge  "Εγκατάσταση πακέτων απέτυχε!\n
Παρακαλούμε, ελέγξτε αρχεία καταγραφής εγκατάστασης ${I_Info} и ${I_Err}" 10 50 0
sleep 5
error_exit
else
echo ${progress_bar} | ${DIALOG} --gauge "${list} ολοκληρώθηκε με επιτυχία." 10 50 0
sleep 1
fi
}
install_pkg_debian()
{
ECHO_INFO "Εγκατάσταση πακέτων: $@"
${APTGET} install -y $@ >> ${I_Info} 2>> ${I_Err}
check_error
}
remove_pkg_debian()
{
ECHO_INFO "Απεγκατάσταση πακέτων: $@"
${APTGET} purge -y $@ >> ${I_Info} 2>> ${I_Err}
check_error
}
install_pkg_rhel()
{
ECHO_INFO "Εγκατάσταση πακέτου: $@"
${YUM} -y --disablerepo=epel,rpmforge,ius install $@ >> ${I_Info} 2>> ${I_Err}
check_error
}
remove_pkg_rhel()
{
ECHO_INFO "Απεγκατάσταση πακέτου: $@"
${YUM} remove -y $@ >> ${I_Info} 2>> ${I_Err}
check_error
}
install_pkg_suse()
{
ECHO_INFO "Εγκατάσταση πακέτου: $@"
zypper --non-interactive install -y $@ >> ${I_Info} 2>> ${I_Err}
check_error
}
check_pkg()
{
cmd="$1"
pkg="$2"
for i in $(echo $PATH|sed 's/:/ /g'); do
[ -x $i/${cmd} ] && export HAS_CMD='YES' && break
done
if [ X"${HAS_CMD}" != X'YES' ]; then
ECHO_INFO "Εγκαθίσταται πακέτο: ${pkg}"
eval ${install_pkg} ${pkg}
if [ X"$?" != X"0" ]; then
ECHO_ERROR "Παρακαλώ κάντε εγκατάσταση πρώτα πακέτο ${pkg} ." && error_exit
fi
fi
unset HAS_CMD
}
pkg_install()
{
eval ${install_pkg} $@;
};
pkg_remove()
{
eval ${remove_pkg} $@;
};
error_exit()
{
clear
ECHO_ERROR " Διακοπή λειτουργίας!" && set_lock 255 &&  exit 255
}
check_error()
{
err=$?
if [ X"${err}" != X"0" ]; then
clear
ECHO_ERROR "Κάτι πήγε στραβά..\nΠαρακαλώ, ελέγξτε αρχείων καταγραφής της εγκατάστασης ${I_Info} и ${I_Err}"
set_lock 255 && exit 255;
else
:
fi
}
check_hardware()
{
export KERNEL_NAME="$(uname -s | tr '[a-z]' '[A-Z]')"
arch="$(uname -m)"
case $arch in
i[3456]86) export ARCH='i386' ;;
x86_64|amd64) export ARCH='x86_64' ;;
*)
echo "Η αρχιτεκτονική σας δεν υποστηρίζεται ακόμα: ${arch}."
echo "Υποστηρίζεται μόνο  i386 και x86_64  ${PROG_NAME}."
error_exit
;;
esac
}
extract_pkg()
{
if [ X"$2" = X"" ]; then
DST='.'
else
DST="$2"
fi
if echo $1 | grep '.tar.gz$' >/dev/null 2>&1 ; then
ECHO_DEBUG "Αποσυμπίεση: $1 -> ${DST}"
tar zxf $1 -C $DST
elif echo $1 | grep '.tgz$' >/dev/null 2>&1 ; then
ECHO_DEBUG "Αποσυμπίεση: $1 -> ${DST}"
tar zxf $1 -C $DST
elif echo $1 | grep '.tar.bz2$' >/dev/null 2>&1 ; then
check_pkg ${BIN_BZIP2} ${PKG_BZIP2}
ECHO_DEBUG "Αποσυμπίεση: $1 -> ${DST}"
tar xjf $1 -C $DST
else
ECHO_ERROR "Μη αναγνωρίσιμη μορφή αρχείου.."
set_lock 255
fi
}
check_exit()
{
$DIALOG \
--clear \
--title " Επιβεβαίωση εξόδου από το πρόγραμμα " \
--colors \
--yesno \
"\Διακόπτουμε την εργασία ${PROG_NAME}?\Zn" 6 50
retexit=$?
case $retexit in
$DIALOG_OK)
eval ok_exit;;
$DIALOG_CANCEL)
retval=99
;;
$DIALOG_ESC)
retval=99
;;
esac
}
ok_exit()
{
clear
echo -e "\a"; echo -e "\a"; echo -e "\a";
ECHO_OK " Σενάριο ${PROG_NAME} έχει ολοκληρώσει τη δουλειά του! Επιτυχημένη εγκατάσταση!!!"
exit 0;
}
passw_MySQL()
{
data1="unset"
ERR=""
while [ "${data1}" != "${data2}" ] || [ -z "${data1}" ] || [ X"${PASS_OK}" != X"YES" ]
do
PASS_OK="YES"
if [ X"${RUN_ISP}" != X'install' ] ; then
ASK0=" πληκτρολογήστε"
else
ASK0="δημιουργήστε ένα σύνθετο"
fi
MSG="Παρακαλώ,${ASK0} κωδικό. Με το πλήκτρο BACKSPACE μπορείτε να διορθώσετε το λάθος κωδικό."
exec 3>&1
data1=`$DIALOG --title "Εισαγάγετε τον κωδικό πρόσβασης για root MySQL" \
--insecure "$@" \
--clear "$@" \
--no-cancel \
--passwordbox "${ERR}${MSG}" 16 51 \
2>&1 1>&3`
export password_MySQL=${data1}
retval=$?
exec 3>&-
case $? in
$DIALOG_CANCEL)
error_exit;;
$DIALOG_ESC)
error_exit;;
esac
if [ X"${RUN_ISP}" != X'install' ] ; then
if [ X"$data1" != "" ]; then
mysql -u root -p${data1} -e "use mysql;" >> ${I_Info} 2>> ${I_Err}
if [ X"$?" != X"0" ]; then
PASS_OK="NO"
ERR="\Zb\Κωδικοί δεν ταιριάζουν!!! Επαναλάβετε την πληκτρολόγηση.\Zn\n"
else
PASS_OK="YES"
fi
else
PASS_OK="NO"
ERR="\Zb\Κωδικός είναι κένο!!! Επαναλάβετε την πληκτρολόγηση.\Zn\n"
fi
data2=${data1}
else
ASK0=" επιβεβαιώστε"
exec 3>&1
data2=`${DIALOG} --title "Έλεγχος κωδικού για χρήστη root MySQL" \
--insecure "$@" \
--clear "$@" \
--no-cancel \
--passwordbox "Παρακαλώ,${ASK0} κωδικός. Με το πλήκτρο BACKSPACE μπορείτε να διορθώσετε το λάθος." 16 51 \
2>&1 1>&3`
retval=$?
exec 3>&-
case $? in
$DIALOG_CANCEL)
error_exit;;
$DIALOG_ESC)
error_exit;;
esac
if [ "${data1}" != "${data2}" ]; then ERR="\Zb\Z1Κωδικοί δεν ταιριάζουν! Επαναλάβετε την πληκτρολόγηση.\Zn\n"; fi
if [ -z "${data1}" ]; then ERR="\Zb\Z1Ο κωδικός πρόσβασης δεν πρέπει να είναι κενό! Επαναλάβετε την πληκτρολόγηση.\Zn\n"; fi
fi
done
export password_MySQL=${data2}
}
check_hostname()
{
retval=99
while test $retval != 0 && test $retval != 250
do
exec 3>&1
value=`$DIALOG --ok-label ИЗМЕНИТЬ \
--cancel-label ОСТАВИТЬ \
--title " Ο έλεγχος του ονόματος διακομιστή " \
--form "Παρακαλούμε, ελέγξτε το ονόμα διακομιστή. Από αυτό εξαρτάται σωστή λειτουργεί 
πολλών υπηρεσίών!!!!\n
Αν όλα είναι σωστά, κάντε κλικ στην επιλογή Διατήρηση.
Και αν θέλετε να διορθώσετε, πρώτα, επεξεργαστείτε το όνομα και, στη συνέχεια, κάντε κλικ στο κουμπί ΑΛΛΑΓΗ" \
10 90 0 \
'Όνομα Διακομιστή:' 1 1 ${FULL_HOSTNAME} 1 23 68 0 \
2>&1 1>&3`
retval=$?
exec 3>&-
case $retval in
$DIALOG_OK)
$DIALOG \
--clear \
--title " Επιβεβαίωση " \
--colors \
--yesno \
"Όνομα Διακομιστή: ${value}\n\Z1Όλα είναι σωστά?\Zn" 6 50
case $? in
$DIALOG_OK)
export FULL_HOSTNAME=${value}
$DIALOG \
--clear \
--title " Πληροφορίες " \
--sleep 3 \
--no-collapse --cr-wrap \
--infobox "Όνομα Διακομιστή έχει αλλαχθεί σε:\n${FULL_HOSTNAME}" 4 50
break
;;
$DIALOG_CANCEL)
retval=99;;
$DIALOG_ESC)
retval=99;;
esac
;;
$DIALOG_CANCEL)
$DIALOG \
--clear \
--title " Πληροφορίες " \
--sleep 3 \
--no-collapse --cr-wrap \
--infobox "Το όνομα του διακομιστή είχε παραμείνει η ίδιο:\n${FULL_HOSTNAME}" 4 50
break
;;
$DIALOG_ESC)
retval=99;;
esac
done
};
make_ssl()
{
returncode=0
needed_ssl="FTP"
common_name=${FULL_HOSTNAME}
while test $returncode != 1 && test $returncode != 250
do
returncode=$?
exec 3>&1
value=`$DIALOG  --title " Δημιουργία πιστοποιητικού για $needed_ssl " \
--ok-label "Δημιουργία" \
--item-help \
--colors \
--mixedform \
"Κατά τη συμπλήρωση των πεδίων για τη δημιουργία ψηφιακού πιστοποιητικού, βεβαιωθείτε ότι πληκτρολογείτε συμφωνούν με τα τα πραγματικά δεδομένα.\n
Κατ ' αρχάς, βεβαιωθείτε ότι όλα τα δεδομένα που εισάγονται αποκλειστικά στην αγγλική γλώσσα.\n
Δεύτερον, δεν μπορούν να χρησιμοποιηθούν συντομογραφίες, να γράφετε μόνο τα πλήρη ονόματα.\n
Και τρίτον, σε καμία περίπτωση δεν μπορείτε να χρησιμοποιήσετε τους ακόλουθους χαρακτήρες:\n
\Z1< > ~ ! @ # $ % ^ * / \ ( ) ?.,&\Zn\n
Σημείωση: το σύμβολο \Z1@\Zn επιτρέπεται στο πλαίσιο \"Ηλεκτρονική διεύθυνση\"" \
20 101 0 \
"Το όνομα της χώρας 	(κωδικός 2 γραμμάτων):"	1 1	'GR'			1 55 2  0 0 "\Z1Εισάγετε τον κωδικό για τη χώρα σας. : Υποχρεωτικό!\Zn" \
"Το κράτος, ή το όνομα της επαρχίας (πλήρες όνομα):"	2 1	'Greece'		2 55 40 0 0 "Εισάγετε Το κράτος ή το όνομα επαρχίας." \
"Όνομα πόλης (για παράδειγμα, πόλη):"	3 1	'Thessaloniki'		3 55 40 0 0 "Πληκτρολογήστε Την πόλη." \
"Όνομα οργανισμού (για παράδειγμα, την εταιρεία):"	4 1	'Company GR'	4 55 40 0 0 "Πληκτρολογήστε το πλήρες όνομα του οργανισμού , ή το όνομα του φυσικού προσώπου." \
"Το όνομα τμήματος (π.χ Τμήμα Διακομιστών):"	5 1	'Servers Department'			5 55 40 0 0 "Mονάδα του οργανισμού Σας. Αυτή η επιλογή είναι προαιρετική." \
"Κοινό όνομα       (Common Name):"	6 1	"$common_name"		6 55 40 0 0 "\Z1Κατά τη δημιουργία του πιστοποιητικού του διακομιστή, η τιμή του πεδίου Common Name πρέπει να ταιριάζει με το (FQDN) διακομιστή, στην οποίο θα λειτουργήσει το πιστοποιητικό.\Zn" \
"Ηλεκτρονική διεύθυνση    (e-mail):"	7 1	'support@company.gr'	7 55 40 0 0 "ηλεκτρονική διεύθυνση για την περαιτέρω επιβεβαίωση των δεδομένων. Δεν απαιτείται." \
2>&1 1>&3`
returncode=$?
exec 3>&-
case $returncode in
$DIALOG_OK)
declare -a a
for i in 1 2 3 4 5 6 7
do
a[$i]=`echo "$value" | sed -n "${i}p"`
done
$DIALOG \
--title " Επιβεβαίωση " \
--colors \
--yesno \
"Το όνομα της χώρας 	(κωδικός 2 γραμμάτων): ${a[1]}\n
Το κράτος, ή το όνομα της επαρχίας (πλήρες όνομα): ${a[2]}\n
Όνομα πόλης (για παράδειγμα, πόλη): ${a[3]}\n
Όνομα οργανισμού (για παράδειγμα, την εταιρεία): ${a[4]}\n
Το όνομα τμήματος (για παράδειγμα, το Τμήμα Διακομιστών): ${a[5]}\n
Κοινό όνομα                             (Common Name): ${a[6]}\n
Ηλεκτρονική διεύθυνση                           (e-mail): ${a[7]}\n\n
\Z1Όλα είναι σωστά?\Zn" 13 95
case $? in
$DIALOG_OK)
mkdir -p /etc/ssl/private/
openssl req -x509 -nodes -days 7300 -subj /C="${a[1]}"/ST="${a[2]}"/L="${a[3]}"/O="${a[4]}"/OU="${a[5]}"/CN="${a[6]}"/emailAddress="${a[7]}" -newkey rsa:2048 -keyout /etc/ssl/private/pure-ftpd.pem -out /etc/ssl/private/pure-ftpd.pem >> ${I_Info} 2>> ${I_Err}
chmod 600 /etc/ssl/private/pure-ftpd.pem
$DIALOG \
--clear \
--sleep 3 \
--no-collapse --cr-wrap \
--infobox "Πιστοποιητικό δημιουργήθηκε με επιτυχία!" 3 30
returncode=250
;;
$DIALOG_CANCEL)
returncode=99
;;
esac
;;
$DIALOG_CANCEL)
$DIALOG \
--clear \
--sleep 3 \
--colors \
--no-collapse --cr-wrap \
--infobox "\Z1Δημιουργία πιστοποιητικού απαραίτητο!\Zn" 3 38
returncode=99
;;
esac
done
}
gen_pass()
{
MATRIX="0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz"
LENGTH="8"
while [ "${n:=1}" -le "$LENGTH" ]
do
export PASS="$PASS${MATRIX:$(($RANDOM%${#MATRIX})):1}"
let n+=1
done
echo "$PASS"
exit 0;
}
gen_fail2ban()
{
if
[ X"${DISTRO_CODENAME}" == X"precise" \
-o X"${DISTRO_CODENAME}" == X"squeeze" ]; then
sasl='';
else sasl='
[sasl]
enabled  = true
port     = smtp
filter   = sasl
logpath  = /var/log/mail.log
maxretry = 3
'
fi
if
[ X"${DISTRO_CODENAME}" == X"wheezy" ]; then
pureftpd=''
else
pureftpd='
[pureftpd]
enabled  = true
port     = ftp
filter   = pureftpd
logpath  = /var/log/syslog
maxretry = 3
'
fi
cat << EOF > /etc/fail2ban/jail.local
${pureftpd}
[dovecot-pop3imap]
enabled = true
filter = dovecot-pop3imap
action = iptables-multiport[name=dovecot-pop3imap, port="pop3,pop3s,imap,imaps", protocol=tcp]
logpath = /var/log/mail.log
maxretry = 5
${sasl}
EOF
cat << EOF > /etc/fail2ban/filter.d/pureftpd.conf
[Definition]
failregex = .*pure-ftpd: \(.*@<HOST>\) \[WARNING\] Authentication failed for user.*
ignoreregex =
EOF
cat << EOF > /etc/fail2ban/filter.d/dovecot-pop3imap.conf
[Definition]
failregex = (?: pop3-login|imap-login): .*(?:Authentication failure|Aborted login \(auth failed|Aborted login \(tried to use disabled|Disconnected \(auth failed|Aborted login \(\d+ authentication attempts).*rip=(?P<host>\S*),.*
ignoreregex =
EOF
};
