#!/usr/bin/env bash
#===============================================================================
#
#          FILE: check_distr.sh
#
#         USAGE: ./check_distr.sh
#        AUTHOR: Alexander Wolf (SinglWolf), singlwolf@qip.ru
#  ORGANIZATION: Forum Mini-Server.ru
#       CREATED: 24.09.2013 22:41:44 YEKT
#      REVISION:  -----
# Copyright (c) 2013, Alexander Wolf
#===============================================================================
if [ X"${KERNEL_NAME}" == X"LINUX" ]; then
export DIR_RC_SCRIPTS='/etc/init.d'
if [ -f /etc/redhat-release ]; then
if grep '^CentOS' /etc/redhat-release &>/dev/null; then
export DISTRO='CENTOS'
export SUPPORTED_SCRIPT='NO'
else export UNSUPPORTED_RELEASE='YES'
fi
export PKG_ARCH=".${ARCH}"
if [ X"${DISTRO_VERSION}" == X"6" -a X"${ARCH}" == X"i386" ]; then
export PKG_ARCH=''
fi
elif [ -f /etc/SuSE-release ]; then
export DISTRO='SUSE'
export DISTRO_VERSION="$(grep 'VERSION' /etc/SuSE-release | awk '{print $3}')"
export DISTRO_CODENAME="$(grep 'CODENAME' /etc/SuSE-release | awk '{print $3}' |tr [A-Z] [a-z])"
if echo "${DISTRO_VERSION}" | grep -e '11\.[1234]' -e '12\.[12]' &>/dev/null ; then
export SUPPORTED_SCRIPT='NO'
else export UNSUPPORTED_RELEASE='YES'
fi
elif [ -f /etc/lsb-release ]; then
export DISTRO='UBUNTU'
export DISTRO_ID="$(grep 'DISTRIB_ID' /etc/lsb-release | awk -F'=' '{print $2}')"
export DISTRO_VERSION="$(grep 'DISTRIB_RELEASE' /etc/lsb-release | awk -F'=' '{print $2}')"
export DISTRO_CODENAME="$(grep 'DISTRIB_CODENAME' /etc/lsb-release | awk -F'=' '{print $2}')"
if [ X"${DISTRO_CODENAME}" == X'precise' \
-o X"${DISTRO_CODENAME}" == X'raring' ]; then
export SUPPORTED_SCRIPT='YES'
else export UNSUPPORTED_RELEASE='YES'
fi
elif [ -f /etc/debian_version ]; then
export DISTRO='DEBIAN'
export DISTRO_VERSION="$(cat /etc/debian_version)"
if grep '^5' /etc/debian_version &>/dev/null; then
export DISTRO_VERSION='5'
export DISTRO_CODENAME='lenny'
export SUPPORTED_SCRIPT='NO'
elif grep '^6' /etc/debian_version &>/dev/null; then
export DISTRO_VERSION='6'
export DISTRO_CODENAME='squeeze'
export SUPPORTED_SCRIPT='YES'
elif grep '^7' /etc/debian_version &>/dev/null || \
grep -i '^wheezy' /etc/debian_version &>/dev/null; then
export DISTRO_VERSION='7'
export DISTRO_CODENAME='wheezy'
export SUPPORTED_SCRIPT='YES'
elif grep '^sid' /etc/debian_version &>/dev/null || \
grep -i '^sid' /etc/debian_version &>/dev/null; then
export DISTRO_VERSION='Ελεγμένη ή ασταθής έκδοση'
export DISTRO_CODENAME='jessie/sid'
export SUPPORTED_SCRIPT='NO'
else
export UNSUPPORTED_RELEASE='YES'
fi
export SHELL_NOLOGIN='/usr/sbin/nologin'
fi
elif [ -f /etc/gentoo-release ] || [ X"${KERNEL_NAME}" == X"FREEBSD" ] || [ X"${KERNEL_NAME}" == X'OPENBSD' ]; then
export UNSUPPORTED_RELEASE='YES';
else
echo "Σφάλμα: Διανομή σας δεν υποστηρίζεται ακόμα."
exit 255
fi
if [ X"${UNSUPPORTED_RELEASE}" == X'YES' ]; then
cat <<EOF
******************************************* ΣΦΑΛΜΑ *******************************************
Υποστήριξη τις διανομής σας σε αυτόν το διακομιστή, δεν έχει υλοποιηθεί ακόμα
${PROG_NAME} v.${PROG_VERSION}. Παρακαλώ κάντε κλικ στον παρακάτω σύνδεσμο για να αποκτήσετε
την νεότερη έκδοση ${PROG_NAME} και βρείτε μια λίστα με τις υποστηριζόμενες διανομές GNU/Linux & BSD διανομές και εκδώσεις.
${LINK_SUPPORT}
******************************************* ΣΦΑΛΜΑ *******************************************
EOF
exit 255
fi
if [ X"${DISTRO}" == X"CENTOS" ]; then
export SYS_ROOT_USER='root'
export SYS_ROOT_GROUP='root'
if [ X"${YUM}" != X"" ]; then
export YUM="${YUM}"
else
export YUM="yum -d 2"
fi
export install_pkg='install_pkg_rhel'
export remove_pkg="remove_pkg_rhel"
export LIST_ALL_PKGS='rpm -qa'
export LIST_FILES_IN_PKG='rpm -ql'
export enable_service='enable_service_rh'
export disable_service='disable_service_rh'
export SSL_FILE_DIR="/etc/pki/tls"
export YUM_REPOS_DIR='/etc/yum.repos.d'
export LOCAL_REPO_NAME="${PROG_NAME}"
export LOCAL_REPO_FILE="${YUM_REPOS_DIR}/${LOCAL_REPO_NAME}.repo"
export PKG_DIALOG="dialog${PKG_ARCH}"
export PKG_BZIP2="bzip2${PKG_ARCH}"
elif [ X"${DISTRO}" == X"SUSE" ]; then
export SYS_ROOT_USER='root'
export SYS_ROOT_GROUP='root'
export install_pkg='install_pkg_suse'
export remove_pkg="remove_pkg_suse"
export LIST_ALL_PKGS='rpm -qa'
export LIST_FILES_IN_PKG='rpm -ql'
export enable_service='enable_service_suse'
export disable_service='disable_service_suse'
export SSL_FILE_DIR="/etc/ssl"
export ZYPPER_REPOS_DIR='/etc/zypp/repos.d'
export LOCAL_REPO_NAME="${PROG_NAME}"
export LOCAL_REPO_FILE="${YUM_REPOS_DIR}/${LOCAL_REPO_NAME}.repo"
export PKG_DIALOG="dialog"
export PKG_BZIP2="bzip2"
elif [ X"${DISTRO}" == X"DEBIAN" -o X"${DISTRO}" == X"UBUNTU" ]; then
export SYS_ROOT_USER='root'
export SYS_ROOT_GROUP='root'
if [ X"${APTGET}" != X"" ]; then
export APTGET="${APTGET}"
else
export APTGET="apt-get"
fi
export install_pkg='install_pkg_debian'
export remove_pkg='remove_pkg_debian'
export LIST_ALL_PKGS="dpkg -l |awk '{print $2}'"
export LIST_FILES_IN_PKG='dpkg -L'
export enable_service="enable_service_debian"
export disable_service="disable_service_debian"
export SSL_FILE_DIR="/etc/ssl"
else
echo "Διανομή σας δεν υποστηρίζεται ακόμη."
exit 255
fi
